/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.jdom.DOMNode;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class CreateElementInCUOperation
extends JavaModelOperation {
    protected IDOMCompilationUnit fCUDOM;
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int fInsertionPolicy = 1;
    protected IJavaElement fAnchorElement = null;
    protected boolean fCreationOccurred = true;
    protected DOMNode fCreatedElement;
    protected int fInsertionPosition = -1;
    protected int fReplacementLength = -1;

    public CreateElementInCUOperation(IJavaElement parentElement) {
        super(null, new IJavaElement[]{parentElement});
        this.initializeDefaultPosition();
    }

    protected void checkCanceled() {
        if (!this.isNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(IJavaElement sibling) {
        this.setRelativePosition(sibling, 2);
    }

    public void createBefore(IJavaElement sibling) {
        this.setRelativePosition(sibling, 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block12: {
            block14: {
                block13: {
                    try {
                        this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
                        JavaElementDelta delta = this.newJavaElementDelta();
                        ICompilationUnit unit = this.getCompilationUnit();
                        this.generateNewCompilationUnitDOM(unit);
                        if (!this.fCreationOccurred) break block12;
                        IBuffer buffer = unit.getBuffer();
                        if (buffer == null) {
                            Object var8_4 = null;
                            break block13;
                        }
                        char[] bufferContents = buffer.getCharacters();
                        if (bufferContents == null) {
                            break block14;
                        }
                        char[] elementContents = Util.normalizeCRs(this.getCreatedElementCharacters(), bufferContents);
                        switch (this.fReplacementLength) {
                            case -1: {
                                buffer.append(elementContents);
                                break;
                            }
                            case 0: {
                                buffer.replace(this.fInsertionPosition, 0, elementContents);
                                break;
                            }
                            default: {
                                buffer.replace(this.fInsertionPosition, this.fReplacementLength, elementContents);
                            }
                        }
                        unit.save(null, false);
                        boolean isWorkingCopy = unit.isWorkingCopy();
                        if (!isWorkingCopy) {
                            this.setAttribute("hasModifiedResource", "true");
                        }
                        this.worked(1);
                        this.resultElements = this.generateResultHandles();
                        if (isWorkingCopy || Util.isExcluded(unit) || !unit.getParent().exists()) break block12;
                        int i = 0;
                        while (true) {
                            if (i >= this.resultElements.length) {
                                this.addDelta(delta);
                                break block12;
                            }
                            delta.added(this.resultElements[i]);
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        this.done();
                        throw throwable;
                    }
                }
                this.done();
                return;
            }
            Object var8_5 = null;
            this.done();
            return;
        }
        Object var8_7 = null;
        this.done();
    }

    private char[] getCreatedElementCharacters() {
        return this.fCreatedElement.getCharacters();
    }

    protected abstract IDOMNode generateElementDOM() throws JavaModelException;

    protected void generateNewCompilationUnitDOM(ICompilationUnit cu) throws JavaModelException {
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return;
        }
        char[] prevSource = buffer.getCharacters();
        if (prevSource == null) {
            return;
        }
        this.fCUDOM = new DOMFactory().createCompilationUnit(prevSource, cu.getElementName());
        IDOMNode child = this.generateElementDOM();
        if (child != null) {
            this.insertDOMNode(this.fCUDOM, child);
        }
        this.worked(1);
    }

    protected abstract IJavaElement generateResultHandle();

    protected IJavaElement[] generateResultHandles() {
        return new IJavaElement[]{this.generateResultHandle()};
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.getCompilationUnitFor(this.getParentElement());
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    public abstract String getMainTaskName();

    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        return workspace.getRuleFactory().modifyRule(resource);
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertDOMNode(IDOMNode parent, IDOMNode child) {
        if (this.fInsertionPolicy != 1) {
            IDOMNode sibling = ((JavaElement)this.fAnchorElement).findNode(this.fCUDOM);
            if (sibling != null && this.fInsertionPolicy == 2) {
                sibling = sibling.getNextNode();
            }
            if (sibling != null) {
                sibling.insertSibling(child);
                this.fCreatedElement = (DOMNode)child;
                this.fInsertionPosition = ((DOMNode)sibling).getStartPosition();
                this.fReplacementLength = 0;
                return;
            }
        }
        parent.addChild(child);
        this.fCreatedElement = (DOMNode)child;
        this.fInsertionPosition = ((DOMNode)parent).getInsertionPosition();
        this.fReplacementLength = parent.getParent() == null ? -1 : 0;
    }

    protected void setAlteredName(String newName) {
    }

    protected void setRelativePosition(IJavaElement sibling, int policy) throws IllegalArgumentException {
        if (sibling == null) {
            this.fAnchorElement = null;
            this.fInsertionPolicy = 1;
        } else {
            this.fAnchorElement = sibling;
            this.fInsertionPolicy = policy;
        }
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (this.fAnchorElement != null) {
            IJavaElement domPresentParent = this.fAnchorElement.getParent();
            if (domPresentParent.getElementType() == 12) {
                domPresentParent = domPresentParent.getParent();
            }
            if (!domPresentParent.equals(this.getParentElement())) {
                return new JavaModelStatus(993, this.fAnchorElement);
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

